package unl2rdf;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

import java.util.stream.Stream;

class Unl2RdfTest {

    @Tag("integration")
    @ParameterizedTest(name = "{index} ==> Unl2Rdf.main({arguments})")
    @ArgumentsSource(TestMainShouldNotThrowOnPartialParameterArgumentProvider.class)
    public void TestMainShouldNotThrowOnPartialParameter(String[] args) {
        Assertions.assertDoesNotThrow(() -> Unl2Rdf.main(args));
    }

    @Tag("integration")
    @ParameterizedTest(name = "RuntimeException({index}) ==> Unl2Rdf.main({arguments})")
    @ArgumentsSource(TestMainShouldNotThrowRuntimeExceptionParameterArgumentProvider.class)
    public void TestMainShouldNotThrowRuntimeException(String[] args) {
        Assertions.assertThrows(RuntimeException.class, () -> Unl2Rdf.main(args));
    }

    static class TestMainShouldNotThrowOnPartialParameterArgumentProvider implements ArgumentsProvider {

        @Override
        public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
            return Stream.of(
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/cat.txt", "--output-file", "dotOnly", "--output-type", "dot"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/cat.txt", "--output-file", "rdfOnly", "--output-type", "rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/cat.txt", "--output-file", "dotWithRdf", "--output-type", "dot,rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/exemples_unl.txt", "--output-file", "dotOnly", "--output-type", "dot"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/exemples_unl.txt", "--output-file", "rdfOnly", "--output-type", "rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/exemples_unl.txt", "--output-file", "dotWithRdf", "--output-type", "dot,rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/issue12.txt", "--output-file", "dotOnly", "--output-type", "dot"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/issue12.txt", "--output-file", "rdfOnly", "--output-type", "rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/issue12.txt", "--output-file", "dotWithRdf", "--output-type", "dot,rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/r1.txt", "--output-file", "dotOnly", "--output-type", "dot"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/r1.txt", "--output-file", "rdfOnly", "--output-type", "rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/r1.txt", "--output-file", "dotWithRdf", "--output-type", "dot,rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/r2.txt", "--output-file", "dotOnly", "--output-type", "dot"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/r2.txt", "--output-file", "rdfOnly", "--output-type", "rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/r2.txt", "--output-file", "dotWithRdf", "--output-type", "dot,rdf"})
            );
        }
    }

    static class TestMainShouldNotThrowRuntimeExceptionParameterArgumentProvider implements ArgumentsProvider {

        @Override
        public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
            return Stream.of(
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/issue14.txt", "--output-file", "dotOnly", "--output-type", "dot"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/issue14.txt", "--output-file", "rdfOnly", "--output-type", "rdf"}),
                    Arguments.of((Object) new String[]{"--input-file", "../Examples/issue14.txt", "--output-file", "dotWithRdf", "--output-type", "dot,rdf"})
            );
        }
    }
}