package unl2rdf;

import fr.tetras_libre.unltools.ApplicationStartup;
import fr.tetras_libre.unltools.Convert.ExportUnlDocuments;
import fr.tetras_libre.unltools.DefaultCommandHandlerResolverFactory;
import fr.tetras_libre.unltools.cqrs.ServiceProvider;
import fr.tetras_libre.unltools.unl.exporters.GraphExporterNames;
import fr.tetras_libre.unltools.unl.parser.UnlGraphImporterFromUnlParser;
import picocli.CommandLine;

import java.io.FileWriter;
import java.io.IOException;

public class Unl2Rdf {

    private static ServiceProvider serviceProvider;

    public static void main(String[] args) throws IOException {

        Options options = new Options();

        try {
            CommandLine.ParseResult parseResult = new CommandLine(options).parseArgs(args);

            if (!CommandLine.printHelpIfRequested(parseResult)) {
                serviceProvider = ApplicationStartup.Initialize(DefaultCommandHandlerResolverFactory.create());
                runProgram(options);
            }
        } catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            e.getCommandLine().usage(System.err);
        }
    }

    private static void runProgram(Options options) throws IOException {
        System.out.printf("Source file :  '%s'%n", options.getInputFile().getAbsolutePath());


        var importer = UnlGraphImporterFromUnlParser.FromInputReader(options.getInputStream());
        var handler = serviceProvider.getHandler(ExportUnlDocuments.class);

        for (OutFileType outType : options.getOutputFileType()) {
            String extension = ToExtension(outType);
            String outfileName = options.getOutputFile() + extension;
            FileWriter fileWriter = new FileWriter(outfileName, false);
            var convertCommand = new ExportUnlDocuments(importer, GetExporterName(outType), fileWriter);
            handler.handle(convertCommand);
            fileWriter.close();
            System.out.printf("Graph written into file '%s'%n", outfileName);
        }
    }


    private static String ToExtension(OutFileType outFileType) {
        switch (outFileType) {
            case rdf:
                return ".ttl";
            case dot:
                return ".dot";
        }
        throw new IllegalArgumentException(String.format("unknown fileType '%s", outFileType.toString()));
    }

    private static String GetExporterName(OutFileType fileType) {
        String exporterName = null;
        switch (fileType) {
            case rdf:
                return GraphExporterNames.RDF_EXPORTER;
            case dot:
                return GraphExporterNames.DOT_EXPORTER;
        }

        throw new IllegalArgumentException();
    }

}

