package unl2rdf;

import picocli.CommandLine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Vector;

public class Options {
    @CommandLine.Option(names = "--input-file", description = "Input file name (absolute or relative to current working directory)")
    String inputFile;

    @CommandLine.Option(names = "--output-file", description = "The name of the output file (without extension)", required = true)
    String outputFile;

    @CommandLine.Option(names = "--output-type", description = "Comma separated file type to output file (ie: dot,rdf)")
    String outFileExtensions;

    @CommandLine.Option(names = "--output-Dir", description = "The output dir relative to the current working directory or absolute")
    String outputDir;

    @CommandLine.Option(names = {"-v", "--verbose"}, description = "Verbose mode. Helpful for troubleshooting.")
    private boolean[] verbosity;

    private Optional<Boolean> verbose;

    String getOutputFile() {
        if (this.outputDir == null || this.outputDir.isBlank()) {
            this.outputDir = ".";
        }
        return Paths.get(this.outputDir, this.outputFile).toAbsolutePath().toString();
    }

    Vector<OutFileType> getOutputFileType() {
        String[] strings = this.outFileExtensions.split(",");
        Vector<OutFileType> result = new Vector<>();

        for (String string :
                strings) {
            if (string.equals("rdf")) {
                result.add(OutFileType.rdf);
            } else if (string.equals("dot")) {
                result.add(OutFileType.dot);
            }
        }

        return result;
    }

    public InputStreamReader getInputStream() throws FileNotFoundException {
        if (null != this.inputFile) {
            return new InputStreamReader(new FileInputStream(this.getInputFile()));
        }

        return new InputStreamReader(System.in);
    }

    public File getInputFile() {
        return Paths.get(this.inputFile).toFile();
    }

    public boolean getVerbose() {
        if (!verbose.isPresent()) {
            var result = null != this.verbose
                    && this.verbosity.length > 0;
            if (result != false) {
                for (var verbosity :
                        this.verbosity) {
                    result = result || verbosity;
                }
            }
            verbose = Optional.of(result);
        }
        return this.verbose.get();
    }
}
