# type: ignore
# This module isolates calls to Corese via the py4j interface,
# because py4j has no stubs and pretty much breaks type checkers.
# This is also declared in pyrightconfig.json

import atexit
import subprocess
from time import sleep

from py4j.java_gateway import JavaGateway

from common import *

gateway_cmd = ["java", "-jar", MODULE_DIR + "/../corese-library-python-4.5.0.jar"]

log = get_logger("export_corese")


# Stop Java gateway when exiting script
def exit_handler(gateway):
    if gateway is not None:
        gateway.shutdown()
        log.info("Gateway server stopped.")
    else:
        subprocess.run(["pkill", "--exact", "--full", " ".join(gateway_cmd)])
        log.warning("Gateway server killed.")


def apply_templates() -> str:
    # Start Java gateway
    log.info("Starting Corese gateway server...")
    java_process = subprocess.Popen(gateway_cmd)
    sleep(1)
    gateway = JavaGateway()
    atexit.register(exit_handler, gateway)
    # Import Java classes
    Graph = gateway.jvm.fr.inria.corese.core.Graph
    Load = gateway.jvm.fr.inria.corese.core.load.Load
    Property = gateway.jvm.fr.inria.corese.core.util.Property
    Transformer = gateway.jvm.fr.inria.corese.core.transform.Transformer

    # ==> Create graph, load ontology
    graph = Graph()
    ld = Load.create(graph)
    Property.set(Property.Value.DISABLE_OWL_AUTO_IMPORT, True)
    ld.parse(RDF_FULL_FILE)

    # ==> Run STTL transformation
    tr = Transformer.create(graph, MODULE_DIR + "/../templates/")
    result = tr.transform()
    log.debug("Raw STTL output follows: \n" + result)
    return result
