const express = require('express');
const multer = require('multer');
const app = express();
const port = 3001;
app.use('/static', express.static('uploads'));

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'uploads/') // Make sure this folder exists
  },
  filename: function (req, file, cb) {
    cb(null, file.fieldname + '-' + Date.now())
  }
});

const upload = multer({ storage: storage });

app.post('/upload', upload.single('file'), (req, res) => {
  res.send({
    message: 'File uploaded successfully',
    file: req.file
  });
});

app.listen(port, () => {
  console.log(`Server running on port ${port}`);
});

